-----------------------------------------
--- file:		ragdoll-on-demand.lua ---
--- version:	1.1					  ---
--- author:		sakratt				  ---
-----------------------------------------

--- SETTINGS ---
rod_toggle_key_code = 85 -- Browse key codes here: https://msdn.microsoft.com/en-us/library/aa243025%28v=vs.60%29.aspx









--- RAGDOLL ON DEMAND ---
local ragdollOnDemand = {}
local justInvoked = false

function ragdollOnDemand.tick()
	local playerPed = PLAYER.PLAYER_PED_ID()
	local player = PLAYER.GET_PLAYER_PED(playerPed)
	local playerExists = ENTITY.DOES_ENTITY_EXIST(playerPed)
	if not playerExists then
		return
	end

	if get_key_pressed(rod_toggle_key_code) then
		if not justInvoked and not PED.IS_PED_RAGDOLL(playerPed) then
			PED.SET_PED_CAN_RAGDOLL(playerPed, true)
			PED.SET_PED_TO_RAGDOLL(playerPed, 0, 0, 0, false, false, false)
		end
		justInvoked = true
	else
		justInvoked = false
	end
end

return ragdollOnDemand