------------------------------------------
--- file:		slow-motion-toggle.lua ---
--- version:	1.2					   ---
--- author:		sakratt				   ---
------------------------------------------

--- SETTINGS ---
smt_toggle_key_code = 89 -- Browse key codes here: https://msdn.microsoft.com/en-us/library/aa243025%28v=vs.60%29.aspx

smt_time_scale = .1
smt_aim_time_scale = .15
smt_vehicle_time_scale = .25
smt_multi_time_scale = false -- Whether to use different time scales when in vehicles and when aiming

smt_smooth_transition = true -- Whether to use a transition when changing time
smt_transition_speed = .05









--- SLOW MOTION TOGGLE ---
local slowMotionToggle = {}
local justToggled = false

local active = false
local currentTimeScale = 1

function slowMotionToggle.tick()
	local playerPed = PLAYER.PLAYER_PED_ID()
	local player = PLAYER.GET_PLAYER_PED(playerPed)
	local playerExists = ENTITY.DOES_ENTITY_EXIST(playerPed)
	if not playerExists then
		return
	end

	if get_key_pressed(smt_toggle_key_code) then
		if not justToggled then
			active = not active
		end
		justToggled = true
	else
		justToggled = false
	end
	
	local targetTimeScale = 1
	if active then
		targetTimeScale = smt_time_scale
		if smt_multi_time_scale then
			if PLAYER.IS_PLAYER_FREE_AIMING(player) then
				targetTimeScale = smt_aim_time_scale
			elseif PED.IS_PED_IN_ANY_VEHICLE(player, false) then
				targetTimeScale = smt_vehicle_time_scale
			end
		end	
	end

	if smt_smooth_transition then
		if active then
			if currentTimeScale > targetTimeScale then
				currentTimeScale = currentTimeScale - smt_transition_speed
				if currentTimeScale < targetTimeScale then
					currentTimeScale = targetTimeScale
					slowDown = false
				end
			end
		else
			if currentTimeScale < targetTimeScale then
				currentTimeScale = currentTimeScale + smt_transition_speed
				if currentTimeScale > targetTimeScale then
					currentTimeScale = targetTimeScale
				end
			end
		end
	else
		currentTimeScale = targetTimeScale
	end
	
	GAMEPLAY.SET_TIME_SCALE(currentTimeScale)
	
end

function slowMotionToggle.unload()
	GAMEPLAY.SET_TIME_SCALE(1)
end

return slowMotionToggle